%------------------------------------------------------------------------------
% File     : CSR130^1 : TPTP v9.2.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : In 2009, what's the common feeling between Sue and Mary, and Bill?
% Version  : Especial.
% English  : In the context of year 2009: Does there exists a relation ?R that 
%            holds between Sue and Bill as well as between Mary and Bill?

% Refs     : [Ben10] Benzmueller (2010), Email to Geoff Sutcliffe
% Source   : [Ben10]
% Names    : ef_rv_2.tq_SUMO_local [Ben10]

% Status   : Theorem
% Rating   : 0.25 v8.2.0, 0.27 v8.1.0, 0.33 v7.3.0, 0.40 v7.2.0, 0.50 v7.1.0, 0.43 v7.0.0, 0.38 v6.4.0, 0.43 v6.3.0, 0.50 v6.1.0, 0.83 v6.0.0, 0.67 v5.5.0, 0.60 v5.4.0, 0.50 v5.1.0, 0.75 v5.0.0, 0.50 v4.1.0
% Syntax   : Number of formulae    :   21 (   0 unt;  12 typ;   0 def)
%            Number of atoms       :   19 (   0 equ;   2 cnn)
%            Maximal formula atoms :    3 (   2 avg)
%            Number of connectives :   55 (   2   ~;   0   |;   2   &;  51   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :    9 (   9   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   12 (  11 usr;   8 con; 0-2 aty)
%            Number of variables   :    3 (   0   ^;   2   !;   1   ?;   3   :)
% SPC      : TH0_THM_NEQ_NAR

% Comments : This is a simple test problem for reasoning in/about SUMO.
%            Initally the problem has been hand generated in KIF syntax in
%            SigmaKEE and then automatically translated by Benzmueller's
%            KIF2TH0 translator into THF syntax.
%          : The translation has been applied in two modes: local and SInE.
%            The local mode only translates the local assumptions and the
%            query. The SInE mode additionally translates the SInE-extract
%            of the loaded knowledge base (usually SUMO).
%          : The examples are selected to illustrate the benefits of
%            higher-order reasoning in ontology reasoning.
%          : Note that the universal predicate is excluded for ?R with the 
%            second conjunct in the query.
%------------------------------------------------------------------------------
%----The extracted signature
thf(numbers,type,
    num: $tType ).

thf(holdsDuring_THFTYPE_IiooI,type,
    holdsDuring_THFTYPE_IiooI: $i > $o > $o ).

thf(lAnna_THFTYPE_i,type,
    lAnna_THFTYPE_i: $i ).

thf(lBen_THFTYPE_i,type,
    lBen_THFTYPE_i: $i ).

thf(lBill_THFTYPE_i,type,
    lBill_THFTYPE_i: $i ).

thf(lBob_THFTYPE_i,type,
    lBob_THFTYPE_i: $i ).

thf(lMary_THFTYPE_i,type,
    lMary_THFTYPE_i: $i ).

thf(lSue_THFTYPE_i,type,
    lSue_THFTYPE_i: $i ).

thf(lYearFn_THFTYPE_IiiI,type,
    lYearFn_THFTYPE_IiiI: $i > $i ).

thf(likes_THFTYPE_IiioI,type,
    likes_THFTYPE_IiioI: $i > $i > $o ).

thf(n2009_THFTYPE_i,type,
    n2009_THFTYPE_i: $i ).

thf(parent_THFTYPE_IiioI,type,
    parent_THFTYPE_IiioI: $i > $i > $o ).

%----The translated axioms
thf(ax,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( parent_THFTYPE_IiioI @ lMary_THFTYPE_i @ lAnna_THFTYPE_i ) ).

thf(ax_001,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( parent_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBen_THFTYPE_i ) ).

thf(ax_002,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ lBill_THFTYPE_i ) ).

thf(ax_003,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( likes_THFTYPE_IiioI @ lBob_THFTYPE_i @ lBill_THFTYPE_i ) ).

thf(ax_004,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( likes_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBill_THFTYPE_i ) ).

thf(ax_005,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( parent_THFTYPE_IiioI @ lSue_THFTYPE_i @ lAnna_THFTYPE_i ) ).

thf(ax_006,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( parent_THFTYPE_IiioI @ lMary_THFTYPE_i @ lBen_THFTYPE_i ) ).

thf(ax_007,axiom,
    holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i ) @ ( (~) @ ( likes_THFTYPE_IiioI @ lSue_THFTYPE_i @ lMary_THFTYPE_i ) ) ).

%----The translated conjecture
thf(con,conjecture,
    ? [R: $i > $i > $o] :
      ( holdsDuring_THFTYPE_IiooI @ ( lYearFn_THFTYPE_IiiI @ n2009_THFTYPE_i )
      @ ( ( R @ lSue_THFTYPE_i @ lBill_THFTYPE_i )
        & ( R @ lMary_THFTYPE_i @ lBill_THFTYPE_i )
        & ( (~)
          @ ! [A: $i,B: $i] : ( R @ A @ B ) ) ) ) ).

%------------------------------------------------------------------------------
